#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Bubbles and ringsMod01.fsh    by   satyam  
//https://www.shadertoy.com/view/3cXXDs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Thank You Inigo Quilez for the articles https://iquilezles.org/
// Shadertoy conversion of CuteSister shader

#define PI 3.141592653589793
#define STEPS 200
#define MAXDIST 100
#define MINDIST 0.0001
#define OBJ_NONE 0
#define OBJ_SPHERE 1
#define OBJ_TORUS 2
#define OBJ_PLANE 3
#define OBJ_SPHERE_SINGLE 4

// Helper functions
mat2 Rotation(float angle)
{
    float s = sin(angle);
    float c = cos(angle);
    return mat2(c, -s, s, c);
}

float ModOperator(float x, float y)
{
    return x - y * floor(x / y);
}

float hash(float n)
{
    return fract(sin(n) * 43758.5453);
}

float ease_step(float x, float k)
{
    return floor(x) + (mod(x, 1.0) < k ? smoothstep(0.0, 1.0, smoothstep(0.0, 1.0, (x - floor(x)) / k)) : 1.0);
}

float sdTorus(vec3 p, vec2 t)
{
    vec2 q = vec2(length(p.xz) - t.x, p.y);
    return length(q) - t.y;
}

float sdSphere(vec3 p, float s)
{
    return length(p) - s;
}

float opSmoothUnion(float d1, float d2, float k)
{
    float h = clamp(0.5 + 0.5 * (d2 - d1) / k, 0.0, 1.0);
    return mix(d2, d1, h) - k * h * (1.0 - h);
}

float opSmoothSubtraction(float d1, float d2, float k)
{
    float h = clamp(0.5 - 0.5 * (d2 + d1) / k, 0.0, 1.0);
    return mix(d2, -d1, h) + k * h * (1.0 - h);
}

float opSmoothIntersection(float d1, float d2, float k)
{
    float h = clamp(0.5 - 0.5 * (d2 - d1) / k, 0.0, 1.0);
    return mix(d2, d1, h) + k * h * (1.0 - h);
}

float GetDist(vec3 position, out int objectID)
{
    objectID = OBJ_NONE;

    position.z += iTime;
    position.x += iTime * 0.5;
    float originalZ = position.z;
    float originalX = position.x;

    float distanceToPlane = position.y + sin(originalZ * 1.0 + iTime * 4.0) * 0.1 + sin(originalX * 1.0 + iTime * 4.0) * 0.1;
    float minDist = distanceToPlane;
    objectID = OBJ_PLANE;

    vec3 orbitCenter = vec3(0, 0, 0);

    float orbitX = orbitCenter.x + 4.0 * sin(iTime * 1.0) + iTime * 0.5;
    float orbitZ = orbitCenter.z + 3.2 * cos(iTime * 2.0);

    float v = 6.0;
    v += iTime;
    vec3 positionForTorus = position.xzy - vec3(orbitX, v, orbitZ);
    positionForTorus.xy = Rotation(iTime * 2.0) * positionForTorus.xy;
    float torus = sdTorus(positionForTorus, vec2(0.8, 0.08));

    vec3 positionForTorus2 = position.xzy - vec3(orbitX, v, orbitZ);
    positionForTorus2.yz = Rotation(-iTime * 3.0) * positionForTorus2.yz;
    float torus2 = sdTorus(positionForTorus2, vec2(0.569, 0.05));

    vec3 positionForTorus3 = position.xzy - vec3(orbitX, v, orbitZ);
    positionForTorus3.xy = Rotation(-iTime * 4.0) * positionForTorus3.xy;
    float torus3 = sdTorus(positionForTorus3, vec2(0.36, 0.06));

    vec3 positionForSphere = position.xyz - vec3(orbitX, orbitZ, v);
    float sphere_Center = sdSphere(positionForSphere, 0.2);

    vec3 spherePosition = vec3(0, 0, 1);
    float radius = 0.4;

    position.y += (smoothstep(0.0, 2.0, sin(originalZ * 1.0 + iTime * 4.0)) * clamp(hash(floor(originalZ)), 0.0, 1.0) * 2.0);
    position.y += (smoothstep(0.0, 2.0, sin(originalX * 1.0 + iTime * 4.0)) * clamp(hash(floor(originalZ)), 0.0, 1.0) * 2.0);

    vec3 repeat = position;
    repeat.x = ModOperator(position.x, 2.0) - 1.0;
    repeat.z = ModOperator(position.z, 2.0) - 1.0;

    float sphereDistance = length(repeat - spherePosition) - radius;

    if (sphere_Center < minDist)
    {
        objectID = OBJ_SPHERE_SINGLE;
        minDist = sphere_Center;
    }

    if (torus < minDist || torus2 < minDist || torus3 < minDist)
    {
        objectID = OBJ_TORUS;
        minDist = torus3;
    }

    if (sphereDistance < minDist)
    {
        objectID = OBJ_SPHERE;
        minDist = sphereDistance;
    }

    float ground = opSmoothUnion(distanceToPlane, sphereDistance, 0.6);
    float rotatingSpheres = opSmoothUnion(torus2, torus, 0.2);
    rotatingSpheres = opSmoothUnion(rotatingSpheres, torus3, 0.2);
    rotatingSpheres = opSmoothUnion(rotatingSpheres, sphere_Center, 0.2);

    float finalDist = opSmoothUnion(ground, rotatingSpheres, 0.8);

    return finalDist;
}

float RayMarch(vec3 rayOrigin, vec3 rayDirection, out int hitObjectID)
{
    float distanceOrigin = 0.0;
    hitObjectID = OBJ_NONE;
    int objectID = OBJ_NONE;

    for (int i = 0; i < STEPS; i++)
    {
        vec3 firstPointOfContact = rayOrigin + distanceOrigin * rayDirection;
        float distanceToTheObject = GetDist(firstPointOfContact, objectID);
        distanceOrigin += distanceToTheObject * 0.95;

        if (distanceOrigin > 100.0 || distanceToTheObject < 0.001)
        {
            hitObjectID = objectID;
            break;
        }
    }
    return distanceOrigin;
}

vec3 GetNormal(vec3 position)
{
    vec2 smallMarginShift = vec2(0.0001, 0.0);
    int objectID = OBJ_NONE;
    float distanceToPoint = GetDist(position, objectID);

    vec3 normal = vec3(
        distanceToPoint - GetDist(position - smallMarginShift.xyy, objectID),
        distanceToPoint - GetDist(position - smallMarginShift.yxy, objectID),
        distanceToPoint - GetDist(position - smallMarginShift.yyx, objectID)
    );

    return normalize(normal);
}

vec3 GetLight(vec3 position)
{
    vec3 lightPosition1 = vec3(2.0 * sin(iTime * 0.5), 4.0, -5.0);
    vec3 lightPosition2 = vec3(-3.0, 2.0, -1.0);
    lightPosition2.xz = Rotation(ease_step(iTime * 0.25, 0.25) * (PI / 2.0)) * lightPosition2.xz;
    lightPosition2.xy = Rotation(ease_step(iTime * 0.25 + 0.5, 0.25) * (PI / 2.0)) * lightPosition2.xy;

    vec3 normal = GetNormal(position);

    vec3 lightVector1 = normalize(lightPosition1 - position);
    float diffuse1 = max(dot(normal, lightVector1), 0.0);

    vec3 lightVector2 = normalize(lightPosition2 - position);
    float diffuse2 = max(dot(normal, lightVector2), 0.0);

    vec3 light = vec3(1.0, 0.9, 0.8) * diffuse1 * 0.7 + vec3(0.5, 0.7, 1.0) * diffuse2 * 0.5;

    light += vec3(0.1, 0.1, 0.15);

    return light;
}

vec3 palette(float t)
{
    vec3 a = vec3(0.6, 0.5, 0.6);
    vec3 b = vec3(0.2, 0.2, 0.3);
    vec3 c = vec3(0.8, 0.8, 0.8);
    vec3 d = vec3(0.0, 0.1, 0.2);

    return a + b * cos(6.28318 * (c * t + d));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = vec2(fragCoord.x / iResolution.x - 0.5, fragCoord.y / iResolution.y - 0.5);
    uv.x = uv.x * iResolution.x / iResolution.y;

    vec3 rayOrigin = vec3(0, 1, 0);
    vec3 rayDirection = normalize(vec3(uv.x, uv.y, 1.0));

    int objectID = OBJ_NONE;
    float dist = RayMarch(rayOrigin, rayDirection, objectID);

    float fogAmount = 1.0 - exp2(-dist * 0.069);

    vec3 color = vec3(0, 0, 0);

    if (dist < 100.0)
    {
        vec3 hitPos = rayOrigin + dist * rayDirection;
        vec3 lighting = GetLight(hitPos);

        vec3 normal = GetNormal(hitPos);
        vec3 objectColor = vec3(0, 0, 0);

        if (objectID == OBJ_TORUS)
        {
            vec3 upColor = vec3(3, 1, 0.2);
            vec3 normalColor = vec3(0.8, 0.3, 0.2) * (normal.y * 0.5 + 0.5) +
                               vec3(0.2, 0.5, 0.8) * (normal.x * 0.5 + 0.5) +
                               vec3(0.3, 0.6, 0.3) * (normal.z * 0.5 + 0.5);

            vec3 paletteColor = normalColor + palette(dist * 0.5 + iTime * 1.0);

            float blendFactor = 1.0 * cos(iTime * 2.0);

            objectColor = mix(paletteColor, upColor, blendFactor);
        }
        else if (objectID == OBJ_SPHERE_SINGLE)
        {
            vec3 upColor = vec3(4, 4, 0.2);
            vec3 normalColor = vec3(0.8, 0.3, 0.2) * (normal.y * 0.5 + 0.5) +
                               vec3(0.2, 0.5, 0.8) * (normal.x * 0.5 + 0.5) +
                               vec3(0.3, 0.6, 0.3) * (normal.z * 0.5 + 0.5);

            vec3 paletteColor = normalColor + palette(dist * 0.5 + iTime * 1.0);

            float blendFactor = 0.4 * cos(iTime * 2.0);

            objectColor = mix(paletteColor, upColor, blendFactor);
        }
        else
        {
            objectColor = vec3(0.8, 0.3, 0.2) * (normal.y * 0.5 + 0.5) +
                           vec3(0.2, 0.5, 0.8) * (normal.x * 0.5 + 0.5) +
                           vec3(0.3, 0.6, 0.3) * (normal.z * 0.5 + 0.5);

            objectColor += palette(dist * 0.5 + iTime * 1.0);
        }

        color = objectColor * lighting;

        float rim = 1.0 - max(dot(normal, -rayDirection), 0.0);
        rim = pow(rim, 4.0);
        color += vec3(0.5, 0.7, 1.0) * rim * 0.5;
    }

    color = mix(color, vec3(0.5, 0.6, 0.7), fogAmount);

    float vignette = length(uv - 0.5) * 0.5;
    color *= 1.0 - vignette;

    fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

